﻿var dataTables = {
    itemDisplayMode: { selected: "selected", nonSelected: "nonSelected", always: "always", noRows: "noRows" },
    filterDisplayMode: { buttons: "buttons", dropdown: "dropdown" }
};

//------- UPDATED SELECTOR
$.fn.dataTable.ext.selector["row"].push(function (settings, opts, indexes) {
    var updated = opts.updated;
    var data;
    var out = [];

    if (updated === undefined) {
        return indexes;
    }

    for (var i = 0, ien = indexes.length ; i < ien ; i++) {
        data = settings.aoData[indexes[i]];

        if ((updated === true && data._a4s_updated === true) || (updated === false && !data._a4s_updated)) {
            out.push(indexes[i]);
        }
    }

    return out;
});

// Cell selector
$.fn.dataTable.ext.selector.cell.push(function (settings, opts, cells) {
    var updated = opts.updated;
    var out = [];

    if (updated === undefined) {
        return cells;
    }

    for (var i = 0, ien = cells.length ; i < ien ; i++) {
        var cellNode = $(settings.oInstance.api().cell(cells[i]).node());

        if (cellNode.length > 0 && (updated === true && cellNode.hasClass("updated")) || (updated === false && !cellNode.hasClass("updated"))) {
            out.push(cells[i]);
        }
    }

    return out;
});

//----------- DATA COLUMN SELECTOR
$.fn.dataTable.ext.selector["column"].push(function (settings, opts, indexes) {
    var dataColumn = opts.dataColumn;
    var data;
    var out = [];

    if (dataColumn === undefined) {
        return indexes;
    }

    for (var i = 0, ien = indexes.length ; i < ien ; i++) {
        data = settings.aoColumns[indexes[i]];

        if ((dataColumn === true && data.IsDataColumn === true) || (dataColumn === false && !data.IsDataColumn)) {
            out.push(indexes[i]);
        }
    }

    return out;
});

(function ($) {
    var dataTableConstants = {
        maxFilterLength: 5,
        maxToolBarLength: 5,
        blockElementTimeout: 800,
        numericMinValue: -2147483648,
        numericMaxValue: 2147483647,
        autoUpdateDelay: 10,
        saveStateWaitInterval: 1000
    };

    $.widget("a4.a4datatable", {
        options: {
            pagingType: "full_numbers",
            generateTableStructure: true,
            title: undefined,
            serverSide: true,
            ajaxAction: undefined,
            ajaxParams: {},
            data: [],
            columns: [],
            defaultSorting: [],
            deferRender: true,
            contextMenuItems: [],
            toolBar: undefined,
            toolBarParams: {
                align: "left"
            },
            toolBarItems: [],
            quickFilter: undefined,
            localizableTexts: {},
            stateKey: undefined,
            stateItemId: undefined,
            stateSaveSorting: true,
            allowRowSelection: undefined,
            rememberRowSelection: false,
            limitRowSelection: undefined,
            selectedRows: undefined,
            selectedRowsExpression: undefined,
            displayColumnSelector: undefined,
            displaySearchBox: true,
            advancedFilter: false,
            displayEmptyTopContainer: false,
            style: "compact",
            displayLength: undefined,
            lengthMenu: [10, 20, 50, 100],
            tooltip: undefined,
            childRow: undefined,
            multiEdit: false,
            height: undefined,
            autoUpdate: undefined,
            customCallback: undefined,
            createCallback: undefined,
            customColumns: undefined
        },
        _create: function () {
            var self = this;
            var opt = self.options;
            var loadStateCall = null;
            var toolBarItems = this._getToolBarItems();

            //Initializing container for methods that run before datatable is initialized
            this.container = this.element;
            this.selectedRows = [];

            if (opt.stateKey) {
                loadStateCall = this._loadState();
            }

            $.when(loadStateCall).then(function () {
                //Initializing parameters
                self.allowRowSelection = opt.allowRowSelection;

                if (self.allowRowSelection == undefined) {
                    self.allowRowSelection = _.some(toolBarItems, function (t) {
                        return (!t.DisplayMode || t.DisplayMode == dataTables.itemDisplayMode.selected) && t.Visible != false;
                    });
                }

                //If datatable allows multi edit mode, it is disabled by default. Old grids only in edit mode, will work as expected
                if (opt.multiEdit) {
                    self.editing = false;
                }

                var lengthMenu = opt.lengthMenu;

                var pageLength = 20;

                //Custom page display Length
                if (opt.displayLength && _.isNumber(opt.displayLength)) {
                    lengthMenu.push(opt.displayLength);
                    lengthMenu.sort(function (a, b) { return a - b });
                    lengthMenu = _.uniq(lengthMenu, true);
                    pageLength = opt.displayLength;
                }

                if (self.state && self.state.PageLength) {
                    pageLength = self.state.PageLength;
                }

                //Load first page of data to resolve column names when no columns are defined
                var loadFirstPageCall = null;

                if (opt.serverSide && (!opt.columns || opt.columns.length == 0)) {
                    loadFirstPageCall = self._loadFirstPage(pageLength);
                }

                $.when(loadFirstPageCall).then(function () {
                    self._initializeColumns();

                    //Custom default sorting
                    var defaultSorting = opt.defaultSorting;

                    if (opt.stateSaveSorting && self.state && self.state.Sorting) {
                        defaultSorting = self.state.Sorting;
                    }

                    if (defaultSorting && !_.isArray(defaultSorting)) {
                        var defaultSortColumn = _.isObject(defaultSorting) ? defaultSorting.Column : defaultSorting;

                        var defaultSortIndex = _.findIndex(self.columns, function (c) {
                            return c.name == defaultSortColumn;
                        });

                        var defaultSortDirecion = (defaultSorting.Ascending === undefined || defaultSorting.Ascending === true) ? "asc" : "desc";

                        if (defaultSortIndex > -1)
                            defaultSorting = [defaultSortIndex, defaultSortDirecion];
                    }

                    //Apply Starting Quick Filter
                    if (opt.quickFilter && opt.quickFilter.Items && opt.quickFilter.Items.length > 0) {
                        self.appliedQuickFilter = self._getCurrentQuickFilter();
                    }

                    var tableContents = self.container.html();
                    var table = self._renderTable();
                    var tableDom = self._generateTableDom();

                    var loadDataCall = null;

                    var options = {
                        "pagingType": opt.pagingType,
                        "searching": opt.displaySearchBox,
                        "processing": false,
                        "deferRender": opt.deferRender,
                        "serverSide": opt.serverSide,
                        "data": opt.data,
                        "ajax": function (data, callback, settings) {
                            if (opt.serverSide) {
                                var api = this.api();
                                var container = api.table().container();
                                $(".h-refreshButton", container).addClass("fa-spin disabled");

                                loadDataCall = self._loadServerData(data, callback, settings);
                            }
                        },
                        "preDrawCallback": function (settings) {
                            self._trigger("preDraw");
                        },
                        "drawCallback": function (settings) {
                            var api = this.api();
                            var pageInfo = api.page.info();
                            var container = api.table().container();

                            if (opt.rememberRowSelection && self.selectedRows) {
                                api.rows(function (index, data, node) {
                                    return (opt.selectedRowsExpression && a4.evaluateCondition(opt.selectedRowsExpression, data)) || (_.find(self.selectedRows, function (r) { return r[self.keyColumn] == data[self.keyColumn]; }) != undefined);
                                }).select();
                            }
                            else if (opt.selectedRowsExpression) {
                                self.selectedRows = [];

                                api.rows(function (index, data, node) {
                                    return a4.evaluateCondition(opt.selectedRowsExpression, data);
                                }).select();
                            }
                            else {
                                self.selectedRows = [];
                            }

                            var selectAllCheckBox = $(".h-selectAll", container);
                            selectAllCheckBox.toggle($(".selectRow", container).length > 0);
                            selectAllCheckBox.addClass("fa-square-o").removeClass("fa-check-square");
                            self._toggleToolbarItems(container);
                            self._checkSelectedRowsLimit();
                            self._setSelectedRowsLabel();

                            self._toggleQuickFilter(container);
                            self._toggleMultiEditButton(container);

                            $(".dataTables_paginate", container).toggle(pageInfo.pages > 1);
                            $(".h-refreshButton", container).removeClass("fa-spin disabled");

                            self._adjustColumnHeaders(api);

                            $(".dataTables_scrollBody", self.container).scrollTop(self.currentScrollPosition);

                            self.currentScrollPosition = 0;

                            self.containerId = $(container).attr("id");

                            self._trigger("draw", null, { totalRecords: pageInfo.recordsTotal, displayedRecords: pageInfo.recordsDisplay });
                        },
                        "rowCallback": function (row, data) {
                            self._trigger("rowBeforeCreated", null, { row: row, data: data });
                        },
                        "createdRow": function (row, data, dataIndex) {
                            self._trigger("rowCreated", null, { index: dataIndex, row: row, data: data });
                        },
                        "footerCallback": function (tfoot, data, start, end, display) {
                            self._trigger("footerCreated", null, { footer: tfoot, data: data, start: start, end: end, display: display, additionalData: self.additionalData });
                        },
                        "columns": self.columns,
                        "ordering": true,
                        "order": defaultSorting,
                        "orderClasses": true,
                        "language": self._getDataTableLocalizableTexts(),
                        "dom": tableDom,
                        "autoWidth": false,
                        "pageLength": pageLength,
                        "lengthMenu": lengthMenu,
                        "scrollX": true
                    };

                    if (opt.height) {
                        var height;

                        if (opt.height == "full")
                            height = 200;
                        else
                            height = parseInt(opt.height.replace("px", ""));

                        if (!isNaN(height)) {
                            options["scrollY"] = height;
                            options["scrollCollapse"] = true;
                        }
                    }

                    if (opt.multiEdit) {
                        options["keys"] = {
                            columns: ".editable-column"
                        };
                    }

                    if (self.allowRowSelection) {
                        options["select"] = {
                            style: (opt.limitRowSelection ? "multi" : "os"), selector: ".selectRow:not(.disabled)", info: false
                        };
                    }

                    //Data Tables Events (Refactor bind events to be able to run before initialization)
                    table.on("preInit.dt", function (e, settings) {
                        var api = new $.fn.dataTable.Api(settings);
                        self.dataTable = api;

                        var container = api.table().container();
                        self.container = container;

                        $(container).addClass("a4s-datatable");

                        if (opt.serverSide) {
                            $(container).addClass("ajax");

                            $(".dataTables-content", container).hide();
                            $(".dataTables-message", container).show();
                        }

                        self._renderToolBar(container);
                        self._renderAdvancedFilterToggleButton(container);
                        self._renderMultiEditControls(container);
                        self._renderSettingsMenu(container);
                        self._renderQuickFilter(container);

                        //For fixed height grids
                        if (!opt.serverSide) {
                            self._trigger("ready");
                        }
                        
                        if (opt.createCallback) {
                            opt.createCallback();
                        }
                    });

                    table.on("init.dt", function (e, settings) {
                        var api = new $.fn.dataTable.Api(settings);

                        var container = api.table().container();

                        if (opt.multiEdit) {
                            api.keys.disable();
                        }

                        api.column("UpdatedRow:name").visible(false);

                        self._setEditableItems(container);

                        if (opt.serverSide) {
                            $(".dataTables-content", container).show();
                            $(".dataTables-message", container).hide();

                            self._adjustColumnHeaders(api);
                            self._adjustBodyHeight();
                        }

                        self._initializeSelectedRows();

                        if (self.appliedQuickFilter)
                            self._trigger("applyQuickFilter", null, { filter: self.appliedQuickFilter });

                        self._toggleMultiEditButton(container);

                        self._trigger("ready");
                    });

                    //Should we assign self.dataTable and self.container here? It's already done in preInit.
                    self.dataTable = table.DataTable(options);
                    self.container = self.dataTable.table().container();

                    //---------- Move this code to preInit
                    self._bindEvents();

                    //Search box
                    $(".dataTables_filter", self.container).append(voxco.icons.getIcon("search", "h-filterButton filter-button"));
                    $(".dataTables_filter :input", self.container).attr("placeholder", self._getLocalizableText("Search"));
                    $(".top", self.container).append(tableContents);
                    if (window.location.href.indexOf("Analytics") > -1 || window.location.href.indexOf("TextHighlighter") > -1
                        || window.location.href.indexOf("ImageHeatMap") > -1) {
                        $(".dataTables_filter", self.container).append('<i class="fa fa-angle-double-left hideQuestionPanel" aria-hidden="true"></i>');
                    }
                    $(".h-refreshButton", this.container).attr("title", self._getLocalizableText("Refresh"));

                    if (!opt.serverSide) {
                        if (opt.multiEdit) {
                            self._toggleMultiEdit(true);
                            //self.dataTable.keys.disable(); //If we allow client side with toggle button, we should do this
                        }

                        self._initializeSelectedRows();

                        if (self.appliedQuickFilter)
                            self._trigger("applyQuickFilter", null, { filter: self.appliedQuickFilter });

                        self._adjustBodyHeight();
                    }

                    //Switching header row with advanced filter row
                    if (opt.advancedFilter) {
                        $("thead tr.header-row", self.container).after($("thead tr.advanced-filter", self.container));
                    }

                    //Render title
                    if (opt.title) {
                        $(".title", self.container).html(opt.title);
                    }
                    //---------- Move this code to preInit
                });
            });
        },
        _loadServerData: function (data, callback, settings) {
            var self = this;
            var autoUpdate = this.options.autoUpdate;

            //If first page was already loaded
            if (this.firstPageData) {
                callback(this.firstPageData);
                this.firstPageData = null;
            }
            else {
                self._stopAutoUpdate();

                var ajaxParams = self._getAjaxParams(data);

                return a4.callServerMethod(this.options.ajaxAction, ajaxParams,
                    function (result, textStatus, jqXHR) {
                    if (result) {
                        if (result.d) {
                            result = _.isString(result.d) ? JSON.parse(result.d) : result.d;
                        }

                        self.additionalData = result.additionalData;

                        self._trigger("loadData", null, { ajaxParams: ajaxParams, result: { data: result.aaData, additionalData: result.additionalData } });

                        // It is possible that loadData filtered some members of result.aaData based on permission/visibility. Ajust display and record totals accordingly
                        if (result.aaData.length < ajaxParams.tableParams.PageLength) {
                            if ((result.iTotalRecords == result.iTotalDisplayRecords) && (result.iTotalDisplayRecords < ajaxParams.tableParams.PageLength)) {
                                // Adjust both totals
                                result.iTotalRecords = result.iTotalDisplayRecords = result.aaData.length;
                            }
                        }

                        callback(result);

                        if (autoUpdate) {
                            self._startAutoUpdate();
                        }

                        if (self.options.customCallback) {
                            // data => ajax param sent while fetching data for table, result => table data after filtering
                            // These parameter might be required for custom operation after table load at the end.
                            // textStatus - success/failure, jqXHR for sending some data in response as a4.datatables object cannot be handled directly
                            self.options.customCallback(data, result, textStatus, jqXHR);
                        }
                    }

                    if (self.hasError) {
                        $(".dataTables-content", self.container).show();
                        $(".dataTables-message", self.container).hide();
                        self.hasError = false;
                    }
                },
                function (error) {
                    var errorData = a4.parseAjaxError(error);

                    if (errorData) {
                        self.hasError = true;
                        $(".dataTables-content", self.container).hide();
                        $(".dataTables-message", self.container).addClass("error-message").html(errorData.Message).show();

                        self._trigger("error", null, { message: errorData.Message });
                    }
                });
            }
        },
        _setOption: function (key, value) {
            var options = this.options;
            switch (key) {
                case "ajaxParams":
                    if (!options.ajaxParams) {
                        options.ajaxParams = {};
                    }
                    //Merge with the user specified params
                    options.ajaxParams = _.extend(options.ajaxParams, value);
                    break;
                case "selectedRows":
                    options.selectedRows = value;
                    this.selectedRows = [];
                    this.dataTable.rows().deselect();
                    this._initializeSelectedRows();
                    break;
                case "data":
                    options.data = value;
                    this.dataTable.clear();
                    this.dataTable.rows.add(options.data).draw();
                    break;
                case "defaultSorting":
                    options.defaultSorting = value;
                    this.dataTable.order(options.defaultSorting);
                    break;
                case "multiEdit":
                    options.multiEdit = value;
                    this._toggleMultiEditButton(this.container);
                    break;
            }
        },
        destroy: function () {
            this.dataTable.destroy(true);
            this._stopAutoUpdate();
            $.Widget.prototype.destroy.call(this);
        },
        _loadState: function () {
            var self = this;

            this.state = {};
           
            return a4.callServerMethod(a4.getAction("GetDataTableConfiguration", "Shared", "Home"), { type: this.options.stateKey, itemId: this.options.stateItemId || 0 }, function (result) {
                if (result) {
                    self.state = result;
                }
            });
        },
        //Save state is called x seconds after input is over, to prevent saving state when user is interacting with the grid.
        _saveState: _.debounce(function (isPlainText, calledByBindEvents) {
            var aoData = this.dataTable.ajax.params();
            var settings = this.dataTable.settings();
            var filter = this.appliedQuickFilter;
            var plainText;

            if (this.state && this.state.PlainText) {
                plainText = this.state.PlainText;
            }

            if (!calledByBindEvents) {
                if ((plainText && $(".plainText")[0]) || isPlainText === true) {
                    plainText = true;
                } else if (isPlainText === false) {
                    plainText = false;
                }
            }

            var configuration = {
                Columns: this._getStateColumns(),
                PageLength: settings.page.len(),
                QuickFilter: (!filter || filter.custom) ? null : filter.index,
                Sorting: null,
                Style: null,
                PlainText: plainText
            };

            if (this.options.stateSaveSorting && aoData.order && aoData.order.length > 0) {
                var order = aoData.order[0];
                var sortColumn = aoData.columns[order.column];

                if (sortColumn) {
                    configuration.Sorting = {
                        Column: sortColumn.name, Ascending: order.dir == "asc"
                    };
                }
            }

            if (this.options.stateKey && (!_.isEqual(this.state, configuration) || calledByBindEvents )) {
                this.state = configuration;

                a4.callServerMethod(a4.getAction("UpdateDataTableConfiguration", "Shared", "Home"), { type: this.options.stateKey, itemId: this.options.stateItemId || 0, config: configuration }, function (result) { });

                this._trigger("stateChange", null, configuration);
            }
        }, dataTableConstants.saveStateWaitInterval),
        _getStateColumns: function () {
            var selectedColumns = {};

            $(".settings-menu", this.container).find(":checkbox").each(function (index, element) {
                var columnName = $(element).closest("li").attr("data-column-name");
                selectedColumns[columnName] = { "Visible": $(element).is(":checked"), "Position": index };
            });

            if (this.state)
                return $.extend(true, {}, this.state.Columns, selectedColumns);
            else
                return selectedColumns;
        },
        _toggleAutoUpdate: function () {
            if (this.options.autoUpdate) {
                var selectedItems = this.getSelectedItems();

                if ((selectedItems && selectedItems.length > 0) || this.editing) {
                    this._stopAutoUpdate();
                }
                else {
                    this._startAutoUpdate();
                }
            }
        },
        _toggleToolbarItems: function (container) {
            var toolBarItems = this._getToolBarItems();

            if (toolBarItems && toolBarItems.length > 0) {
                var toolBar = $(".toolBar", container);
                var filter = $(".filter-bar", container);
                var self = this;

                var selectedItems = this.getSelectedItems();

                if ($(".dataTables_empty", container).length > 0) {
                    _.each(toolBarItems, function (item) {
                        item.Visible = a4.evaluateCondition(item.DisplayCondition) && (item.DisplayMode == dataTables.itemDisplayMode.always || item.DisplayMode == dataTables.itemDisplayMode.noRows);
                    });
                }
                else if (selectedItems && selectedItems.length > 0) {
                    _.each(toolBarItems, function (item) {
                        item.Visible = false;

                        if (item.DisplayMode != dataTables.itemDisplayMode.nonSelected && item.DisplayMode != dataTables.itemDisplayMode.noRows && !item.Disabled)
                            item.Visible = (typeof item.DisplayCondition == "undefined") || _.every(selectedItems, function (row) { return a4.evaluateCondition(item.DisplayCondition, row); });
                    });
                }
                else {
                    _.each(toolBarItems, function (item) {
                        item.Visible = a4.evaluateCondition(item.DisplayCondition) && typeof item.DisplayMode != "undefined" && item.DisplayMode != dataTables.itemDisplayMode.selected && item.DisplayMode != dataTables.itemDisplayMode.noRows;
                    });
                }

                _.each(toolBarItems, function (item) {
                    $("[data-position=" + item.Position + "]", toolBar).toggleClass("hidden", !item.Visible);
                });

                var showToolBar = _.some(toolBarItems, function (item) { return item.Visible });

                $(".actions-button", toolBar).toggleClass("hidden", !showToolBar); //Buttons as dropdown
                toolBar.toggleClass("hidden", !showToolBar);

                var onlyAlwaysVisibleButtons = _.every(toolBarItems, function (item) { return !item.Visible || item.DisplayMode == dataTables.itemDisplayMode.always; });
                var showFilter = this.options.quickFilter && (this.options.quickFilter.AlwaysVisible || !showToolBar || onlyAlwaysVisibleButtons);

                filter.toggleClass("hidden", !showFilter);
            }
        },
        _getDataTableLocalizableTexts: function () {
            return {
                lengthMenu: this._getLocalizableText("LengthMenu"),
                emptyTable: this._getLocalizableText("EmptyTable"),
                info: this._getLocalizableText("Info"),
                infoEmpty: this._getLocalizableText("InfoEmpty"),
                infoFiltered: this._getLocalizableText("InfoFiltered"),
                zeroRecords: this._getLocalizableText("ZeroRecords"),
                paginate: {
                    "info": this._getLocalizableText("PaginateInfo"),
                    "first": "<span class='fa fa-lg fa-angle-double-left'></span>",
                    "previous": "<span class='fa fa-lg fa-angle-left'></span>",
                    "next": "<span class='fa fa-lg fa-angle-right'></span>",
                    "last": "<span class='fa fa-lg fa-angle-double-right'></span>"
                },
                search: "",
                loadingRecords: "",
                processing: ""
            };
        },
        _getLocalizableText: function (key) {
            var text = undefined;

            try {
                if (this.options.localizableTexts[key]) {
                    text = this.options.localizableTexts[key];
                }
                else if (dataTableResources && dataTableResources[key]) {
                    text = dataTableResources[key];
                }
                else if (sharedResources && sharedResources[key]) {
                    text = sharedResources[key];
                }
                else if (resources && resources[key]) {
                    text = resources[key];
                }
            }
            catch (err) {
            }

            return text;
        },
        _initializeColumns: function () {
            var columns = [];
            var self = this;

            //Select row column
            if (this.allowRowSelection) {
                columns.push({
                    name: "SelectRow",
                    data: function (source, type, val) {
                        var data = "";

                        if (type == "display" && a4.evaluateCondition(self.allowRowSelection, source)) {
                            data = "<span class='fa fa-fw selectRow'></span>";
                        }

                        return data;
                    },
                    width: "25px",
                    orderable: false,
                    searchable: false,
                    IsDataColumn: false,
                    className: "icon-column"
                });
            }

            //Updated status column
            if (this.options.multiEdit) {
                columns.push({
                    name: "UpdatedRow",
                    data: function (source, type, val) {
                        return voxco.icons.getIcon("edit", "updatedRow");
                    },
                    width: "25px",
                    orderable: false,
                    searchable: false,
                    IsDataColumn: false,
                    className: "icon-column"
                });
            }

            //Details column
            if (this.options.childRow) {
                var detailsColumn = {};
                var detailsCondition = this.options.childRow.DisplayCondition;

                detailsColumn.className = "details-column icon-column";
                detailsColumn.name = "Details";
                detailsColumn.width = "10px";
                detailsColumn.orderable = false;
                detailsColumn.data = function (source, type, val) {
                    var visible = false;

                    if (type == "display" && (_.isFunction(self.options.childRow.Render) || source[self.options.childRow.Render])) {
                        visible = detailsCondition ? a4.evaluateCondition(detailsCondition, source) : true;
                    }

                    return visible ? "<span class='fa fa-lg toggle-child-row h-toggleChildRow'></span>" : "";
                };

                if (this.options.childRow.Position)
                    columns.splice(this.options.childRow.Position, 0, detailsColumn);
                else
                    columns.push(detailsColumn);
            }

            //Auto bind columns
            if (!this.options.columns || this.options.columns.length == 0) {
                this._bindColumnsFromData();
            }

            _.each(this.options.columns, function (col) {
                columns.push(self._createColumn(col));
            });

            //Context menu column
            if (this.options.contextMenuItems.length > 0) {
                columns.push({
                    name: "ActionsMenu",
                    data: null,
                    render: function (data, type, row, meta) {
                        return "<div class='displayOnHover'></div>";
                    },
                    width: "65px",
                    className: "action-menu-column",
                    orderable: false,
                    searchable: false,
                    IsDataColumn: false
                });
            }
            else if (this.options.advancedFilter) {
                columns.push({
                    name: "AdvancedFilterMenu",
                    data: null,
                    defaultContent: "",
                    width: "42px",
                    orderable: false,
                    searchable: false,
                    IsDataColumn: false
                });
            }

            this.columns = columns;

            return columns;
        },
        _loadFirstPage: function (pageLength) {
            var self = this;

            var ajaxParams = this._getAjaxParams({ draw: 1, start: 0, length: pageLength });

            return a4.callServerMethod(this.options.ajaxAction, ajaxParams, function (result) { self.firstPageData = result; });
        },
        _bindColumnsFromData: function () {
            var firstRow = null;

            if (this.firstPageData && this.firstPageData.aaData && this.firstPageData.aaData.length > 0)
                firstRow = this.firstPageData.aaData[0];
            else if (typeof this.options.data !== "undefined")
                firstRow = this.options.data[0];

            if (firstRow != null) {
                for (var property in firstRow) {
                    if (firstRow.hasOwnProperty(property)) {
                        this.options.columns.push({
                            Name: property, Editable: this.options.multiEdit && property.toLowerCase() != "id"
                        });
                    }
                }
            }
        },
        _createColumn: function (column) {
            var self = this;
            var dataTableColumn = {};
            var sortable = (column.Sortable === undefined || column.Sortable) && !column.Index && column.Tooltip !== true;
            var cssClass;
            var options = this.options;

            cssClass = "value-column";

            if (column.Class) {
                cssClass += " " + column.Class;
            }

            if (column.Name === undefined && column.Data !== undefined) {
                column.Name = column.Data;
            }
            else if (column.Data === undefined && column.Name !== undefined) {
                column.Data = column.Name;
            }

            var title = column.Title;

            if (title == null && !column.Tooltip) {
                title = this._getLocalizableText(column.Name) || column.Name;
            }

            dataTableColumn.title = "<span class='column-title'>" + (title || "") + "</span>" + (sortable ? voxco.icons.getIcon("caret-up") + voxco.icons.getIcon("caret-down") : "");

            var columnWidth = column.Width;

            if (column.Type == "date" || column.Type == "datetime" || column.Type == "numeric") {
                cssClass += " no-wrap";
            }

            dataTableColumn.width = columnWidth;
            dataTableColumn.type = column.Type;
            dataTableColumn.orderable = sortable;
            dataTableColumn.searchable = column.Searchable !== false && this._isVisibleColumn(column);
            dataTableColumn.orderData = column.DataSort;
            dataTableColumn.visible = this._isVisibleColumn(column);
            dataTableColumn.data = column.Data;
            dataTableColumn.name = column.Name;
            dataTableColumn.defaultContent = column.DefaultValue;
            dataTableColumn.render = column.render;
            
            if (column.Editable) {
                cssClass += " editable-column" + " " + "v-" + dataTableColumn.name.toLowerCase();
            }

            if (column.Label) { //Check need for this
                dataTableColumn.render = function (data, type, row, meta) {
                    return row[column.Label];
                }
            }
            else if (column.Prefix || column.Suffix) {
                dataTableColumn.render = function (data, type, row, meta) {
                    if (data) {
                        return (column.Prefix || "") + data + (column.Suffix || "");
                    }

                    return "";
                }
            }
            else if (column.Type == "boolean" && column.ShowIcon) {
                cssClass += " icon-column";

                dataTableColumn.render = function (data, type, row, meta) {
                    return !!data ? voxco.icons.getIcon("check") : "";
                };
            }
            else if (column.Tooltip === true) {
                cssClass += " tooltip-column icon-column";

                dataTableColumn.render = function (data, type, row, meta) {
                    var visible = !!column.DisplayCondition ? a4.evaluateCondition(column.DisplayCondition, row) : true;

                    return !!data && visible ? voxco.icons.getIcon(column.Icon || "warning") : "";
                };
            }

            if (column.Index && !dataTableColumn.data) {
                dataTableColumn.data = function (row, type, set, meta) {
                    var index = meta.row + 1;

                    if (options.serverSide) {
                        index += meta.settings._iDisplayStart;
                    }

                    row.Index = index;

                    return index;
                };
            }

            dataTableColumn.createdCell = function (cell, cellData, rowData, rowIndex, colIndex) {
                if (column.Editable) {
                    var editableCondition = _.isObject(column.Editable) ? column.Editable.DisplayCondition : column.Editable;

                    if (editableCondition && !a4.evaluateCondition(editableCondition, rowData)) {
                        $(cell).removeClass("editable-column");
                        if (column.ShowIcon) {
                            $(cell).addClass("icon-column-disabled");
                        }
                    }
                }

                if (column.EncodeHtml) {
                    $(cell).text(cellData);
                }

                if (_.isString(column.Tooltip) && column.Tooltip in rowData) {
                    $(cell).addClass("tooltip-column");
                    $(cell).attr("data-tooltip", rowData[column.Tooltip]);
                }

                self._trigger("cellCreated", null, {
                    cell: cell, data: cellData, row: rowData, rowIndex: rowIndex, colIndex: colIndex, fieldName: column.Name, flagError: function (disableSave, fullRow) {
                        if (disableSave) {
                            $(".multi-edit-bar .save", self.container).addClass("disabled");
                        }

                        $(cell).addClass("error");
                    }
                });
            };

            if (column.Key) {
                this.keyColumn = column.Name;
            }

            dataTableColumn.className = cssClass;

            //Aditional properties            
            dataTableColumn.IsDataColumn = !column.Tooltip;
            dataTableColumn.HideInSelector = column.HideInSelector;
            dataTableColumn.AdvancedFilter = column.AdvancedFilter;
            dataTableColumn.AdvancedFilterLabels = column.AdvancedFilterLabels;
            dataTableColumn.EnumType = column.EnumType;
            dataTableColumn.Editable = column.Editable;

            return dataTableColumn;
        },
        _getColumnByName: function (name) {
            return _.find(this.columns, function (column) {
                return column.name == name
            });
        },
        _isVisibleColumn: function (column) {
            var isVisible = column.Visible !== false ;

            if (!column.HideInSelector && column.Tooltip !== true && this.state && this.state.Columns && this.state.Columns[column.Name]) {
                isVisible = this.state.Columns[column.Name].Visible;
            }

            return isVisible;
        },
        _renderTable: function () {
            var table = this.container;
            var columns = this.columns;
            var self = this;

            var style = this.options.style || "";

            if (this.state && this.state.Style) {
                style = this.state.Style;
            }

            if (this.options.generateTableStructure) {
                table = $("<table />", {
                    "class": style
                });

                var tableHead = $("<thead />");

                self._renderAdvancedFilterRow(tableHead);

                //Render header row
                var headerRow = $("<tr />", {
                    "class": "header-row"
                });

                _.each(columns, function (column, index) {
                    var cell = $("<th />", {
                        "data-column-name": column.Name
                    });

                    if (index == 0 && self.allowRowSelection != false && !self.options.limitRowSelection) {
                        cell.append($("<span />", { "class": "fa fa-fw fa-square-o h-selectAll", "title": self._getLocalizableText("SelectAllRows") }));
                    }

                    headerRow.append(cell);
                });

                //Render content row
                tableHead.append(headerRow);

                var tableBody = $("<tbody />");
                var contentRow = $("<tr />");

                _.each(columns, function (column) {
                    contentRow.append($("<td />"));
                });

                tableBody.append(contentRow);

                table.append(tableHead);
                table.append(tableBody);

                this.container.empty();
                this.container.append(table);
            }
            else {
                if (this.options.advancedFilter) {
                    this._renderAdvancedFilterRow($("thead", this.container));
                }
                else {
                    $("th.advanced-filter, td.advanced-filter", this.container).detach();
                }
            }

            return table;
        },
        _generateTableDom: function () {
            var filterSection = "";
            var columnSelector = "";
            var advancedFilterToggleButton = "";
            var multiEditToggleButton = "";
            var multiEditSaveBar = "";
            var toolBar = "";
            var toolBarRight = "";
            var filter = "";
            var top = "";
            var hasTop = this.options.displayEmptyTopContainer;
            var title = "";
            var tableContent = "";
            var opt = this.options;

            if (opt.displaySearchBox) {
                filterSection = 'f';
                hasTop = true;
            }

            if (opt.multiEdit) {
                multiEditToggleButton = '<"multi-edit-toggle">';
                multiEditSaveBar = '<"multi-edit-bar">';
                hasTop = true;
            }

            if (opt.displayColumnSelector == true || opt.displayColumnSelector == undefined) {
                columnSelector = '<"settings-menu">';
                hasTop = true;
            }

            if (opt.advancedFilter) {
                advancedFilterToggleButton = '<"advanced-filter-toggle">';
                hasTop = true;
            }

            var toolBarItems = this._getToolBarItems();

            if (toolBarItems.length > 0) {
                toolBar = '<"toolBar clearfix">';
                hasTop = true;
                if (opt.toolBarParams.align == "right") {
                    toolBarRight = toolBar;
                    toolBar = "";
                }
            }

            if (opt.quickFilter) {
                filter = '<"filter-bar">';
                hasTop = true;
            }

            if (opt.title) {
                title = '<"title">'
            }

            if (hasTop) {
                if (filter.length == 0 && toolBar.length == 0) {
                    top = '<"top clearfix"' + title + columnSelector + multiEditToggleButton + advancedFilterToggleButton + filterSection + multiEditSaveBar + '>';
                    title = '';
                }
                else {
                    top = '<"top clearfix"' + toolBar + filter + columnSelector + multiEditToggleButton + advancedFilterToggleButton + toolBarRight + filterSection + multiEditSaveBar + '>';
                }
            }

            tableContent = '<"dataTables-content" ' + title + top + 't<"bottom clearfix no-print"i<"v-selectedRows selected-rows">';

            if (opt.serverSide) {
                tableContent += '<"h-refreshButton refresh-button fa fa-lg fa-refresh">';
            }

            tableContent += 'pl' + multiEditSaveBar + '>>';

            if (opt.serverSide) {
                tableContent += '<"dataTables-message"<"fa fa-circle-o-notch fa-spin fa-fw">>';
            }

            tableContent += '<"context-menus">';

            return tableContent;
        },
        _evaluateContextMenuDisplayCondition: function (menuItem, rowData) {
            var displayItem = (menuItem.Visible == undefined || menuItem.Visible);

            if (displayItem && rowData && menuItem && menuItem.DisplayCondition) {
                displayItem = a4.evaluateCondition(menuItem.DisplayCondition, rowData);
            }

            return displayItem;
        },
        _renderContextMenu: function (row, rowIndex) {
            var contextMenuId = this.containerId + "_contextmenu_" + rowIndex;

            var menuButton = $("<div />", { "class": "displayOnHover", "data-dropdownId": contextMenuId });

            var self = this;

            var itemsToDisplay = _.filter(this.options.contextMenuItems, function (i) {
                var displayItem = self._evaluateContextMenuDisplayCondition(i, row);

                if (i.SubMenuItems) {
                    i.SubMenuItemsToDisplay = _.filter(i.SubMenuItems, function (j) {
                        return self._evaluateContextMenuDisplayCondition(j, row);
                    });

                    displayItem = displayItem && i.SubMenuItemsToDisplay.length > 0;
                }

                return displayItem;
            });

            if (itemsToDisplay.length > 0) {
                //Remove all dividers from beggining of array
                while (itemsToDisplay[0] && itemsToDisplay[0].Divider)
                    itemsToDisplay.shift();

                //Remove all dividers from end of array
                while (itemsToDisplay[itemsToDisplay.length - 1] && itemsToDisplay[itemsToDisplay.length - 1].Divider)
                    itemsToDisplay.splice(itemsToDisplay.length - 1);
            }

            if (itemsToDisplay.length > 0) {
                menuButton.append($("<div />", { "class": "button icon-only dropdown-toggle", "title": this._getLocalizableText("ContextMenu") })
                .append(voxco.icons.getIcon("menu"))
                .append(voxco.icons.getIcon("caret-down", "icon-right"))).addClass("button-group dropdown-container");

                var contextMenu = $(".context-menus #" + contextMenuId, self.container);

                if (contextMenu.length == 0) {
                    contextMenu = $("<ul />", { "id": contextMenuId, "class": "dropdown-menu" });
                    $(".context-menus", self.container).append(contextMenu);
                }
                else {
                    contextMenu.empty();
                }

                _.each(itemsToDisplay, function (item, index, list) {
                    var attributes = {};

                    if (item.Divider) {
                        var nextItem;

                        if (index < list.length - 1)
                            nextItem = list[index + 1];

                        if (nextItem && !nextItem.Divider) {
                            attributes["class"] = "divider";
                            contextMenu.append($("<li />", attributes));
                        }
                    }
                    else {
                        attributes["class"] = "v-contextMenuItem";
                        attributes["data-action"] = item.Action;

                        if (item.Params) {
                            attributes["data-params"] = JSON.stringify(item.Params);
                        }

                        var menuItem = $("<li />", attributes).append($("<a />").append($("<span />", { "class": "item-label", "text": item.Label })));

                        if (item.SubMenuItemsToDisplay && item.SubMenuItemsToDisplay.length > 0) {
                            $("a", menuItem).append(voxco.icons.getIcon("caret-right", "submenu-icon"));

                            var subMenu = $("<ul />", { "class": "dropdown-submenu left" });

                            _.each(item.SubMenuItemsToDisplay, function (subMenuItem) {
                                var attributes = {
                                    "class": "v-contextMenuItem", "data-action": subMenuItem.Action
                                };

                                if (subMenuItem.Params) {
                                    attributes["data-params"] = JSON.stringify(subMenuItem.Params);
                                }

                                subMenu.append($("<li />", attributes).append($("<a />", {
                                    "text": subMenuItem.Label
                                })));
                            });

                            menuItem.append(subMenu);
                        }

                        contextMenu.append(menuItem);
                    }

                    previousItem = item;
                });
            }

            return menuButton.outerHTML();
        },
        _renderEditableCellInput: function (column, data) {
            var input;
            var nullable = !_.isObject(column.Editable) || typeof column.Editable.Nullable === 'undefined' || column.Editable.Nullable === true;

            if (column.type == "enum") {
                input = this._renderEnumControl(column.EnumType, data, nullable);
            }
            else if (column.type == "boolean") {
                input = this._renderBoolControl(column.AdvancedFilterLabels, data, nullable);
            }
            else if (column.type == "richtext") {
                input = $("<div />", { "class": "v-richText", "html": data });
            }
            else if (column.type == "numeric" || column.type == "datetime" || column.type == "date" || column.type == "time" || column.type == "multiple") {
                input = $("<input />", { "type": "text", "value": data });
            }
            else {
                input = $("<textarea />");
                input.val(data);
            }

            input.addClass("editable");

            if (column.type) {
                input.attr("data-type", column.type);
            }

            return input;
        },
        _renderToolBar: function (container) {
            var toolBar = $(".toolBar", container);
            var toolBarItems = _.filter(this._getToolBarItems(), function (item) { return item.Visible != false });
            var toolBarParams = this._getToolBarParams();
            var displayMode = this.options.toolBar ? this.options.toolBar.DisplayMode : undefined;

            if (toolBarItems && toolBarItems.length > 0) {
                toolBar.addClass("toolBar-" + toolBarParams.align);

                if ((displayMode == undefined && toolBarItems.length <= dataTableConstants.maxToolBarLength) || displayMode == dataTables.filterDisplayMode.buttons) {
                    for (var i = 0; i < toolBarItems.length; i++) {
                        toolBarItems[i].Position = i;
                        var item = toolBarItems[i];

                        var button = $("<div />", {
                            "class": "button v-toolBarButton", "data-action": item.Action, "data-position": i
                        }).append(item.Label);

                        if (!item.DisplayMode || item.DisplayMode == dataTables.itemDisplayMode.selected) {
                            button.addClass("hidden");
                        }

                        toolBar.append(button);
                    }
                }
                else {
                    var buttonGroup = $("<div />", {
                        "class": "button-group dropdown-container actions-button"
                    });

                    buttonGroup.append($("<div />", {
                        "class": "button dropdown-toggle"
                    }).append(this._getLocalizableText("Actions")).append(voxco.icons.getIcon("caret-down", "icon-right")));

                    var menuItems = $("<ul />", {
                        "class": "dropdown-menu " + toolBarParams.align + "-align"
                    });

                    for (var i = 0; i < toolBarItems.length; i++) {
                        toolBarItems[i].Position = i;
                        var item = toolBarItems[i];

                        var listItem = $("<li />", { "class": "v-toolBarButton", "data-action": item.Action, "data-position": i }).append($("<a />", { "text": item.Label }));

                        if (!item.DisplayMode || item.DisplayMode == dataTables.itemDisplayMode.selected) {
                            listItem.addClass("hidden");
                        }

                        menuItems.append(listItem);
                    }

                    buttonGroup.append(menuItems);

                    toolBar.append(buttonGroup);
                }
            }
        },
        _renderQuickFilter: function (container) {
            var filter = $(".filter-bar", container);

            if (filter.length > 0) {
                var filterItems = this.options.quickFilter.Items;
                var filterItemsLength = filterItems.length + 1 + (this.options.quickFilter.IncludeSelectedStates ? 2 : 0);
                var selectedFilter;

                var buttonGroup = $("<div />", {
                    "class": "button-group"
                });

                if ((this.options.quickFilter.DisplayMode == undefined && filterItemsLength <= dataTableConstants.maxFilterLength) || this.options.quickFilter.DisplayMode == dataTables.filterDisplayMode.buttons) {
                    filter.addClass("buttons");

                    if (this.options.quickFilter.IncludeAll !== false) {
                        buttonGroup.append($("<div />", { "class": "button v-quickFilterButton" }).append(this._getLocalizableText("All")));
                    }

                    if (this.options.quickFilter.IncludeSelectedStates) {
                        buttonGroup.append($("<div />", { "class": "button v-quickFilterButton v-selected" }).append(this._getLocalizableText("Selected")));
                        buttonGroup.append($("<div />", { "class": "button v-quickFilterButton v-notSelected" }).append(this._getLocalizableText("NotSelected")));
                    }

                    for (var i = 0; i < filterItems.length; i++) {
                        if ((typeof filterItems[i].Visible == "undefined") || filterItems[i].Visible) {
                            filterItems[i].Index = i;
                            var button = $("<div />", { "class": "button v-quickFilterButton" }).append(filterItems[i].Label).attr("data-index", i);
                            buttonGroup.append(button);

                            if (filterItems[i].CustomInputs && filterItems[i].CustomInputs.length > 0) {
                                filter.append(this._renderQuickFilterCustomPanel(i, filterItems[i]));
                            }
                        }
                    }

                    if (this.state && this.state.QuickFilter != undefined && filterItems[this.state.QuickFilter] != undefined && a4.evaluateCondition(filterItems[this.state.QuickFilter].DisplayCondition))
                        selectedFilter = $(".button[data-index='" + this.state.QuickFilter + "']", buttonGroup);

                    if (!selectedFilter || selectedFilter.length == 0)
                        selectedFilter = $(".button:first", buttonGroup);
                }
                else {
                    filter.addClass("dropdown");

                    buttonGroup.append($("<div />", { "class": "button dropdown-toggle" }).append(voxco.icons.getIcon("filter", "icon-left")).append($("<span />", { "class": "v-currentFilterLabel" })).append(voxco.icons.getIcon("caret-down", "icon-right"))).addClass("dropdown-container");

                    var menuItems = $("<ul />", { "class": "dropdown-menu left-align" });

                    if (this.options.quickFilter.IncludeAll !== false) {
                        menuItems.append($("<li />").append($("<a />", {
                            "text": this._getLocalizableText("All")
                        })));
                    }

                    if (this.options.quickFilter.IncludeSelectedStates) {
                        menuItems.append($("<li />", { "class": "v-selected" }).append($("<a />", { "text": this._getLocalizableText("Selected") })));
                        menuItems.append($("<li />", { "class": "v-notSelected" }).append($("<a />", { "text": this._getLocalizableText("NotSelected") })));
                    }

                    for (var i = 0; i < filterItems.length; i++) {
                        if ((typeof filterItems[i].Visible == "undefined") || filterItems[i].Visible) {
                            filterItems[i].Index = i;

                            var listItem = $("<li />", { "class": "v-quickFilterButton", "data-index": i }).append($("<a />", { "text": filterItems[i].Label }));

                            menuItems.append(listItem);

                            if (filterItems[i].CustomInputs && filterItems[i].CustomInputs.length > 0) {
                                filter.append(this._renderQuickFilterCustomPanel(i, filterItems[i]));
                            }
                        }
                    }

                    if (this.state && this.state.QuickFilter != undefined)
                        selectedFilter = $("li[data-index='" + this.state.QuickFilter + "']", menuItems);

                    if (!selectedFilter || selectedFilter.length == 0)
                        selectedFilter = $("li:first", menuItems);

                    buttonGroup.append(menuItems);

                    $(".v-currentFilterLabel", buttonGroup).text(selectedFilter.text())
                }

                selectedFilter.addClass("selected");

                filter.prepend(buttonGroup);
            }
        },
        _renderQuickFilterCustomPanel: function (index, filter) {
            var customFilter = $("<div />", {
                "class": "custom-filter-panel", "data-index": index
            });

            _.each(filter.CustomInputs, function (e) {
                customFilter.append($("<input />", {
                    "type": "text", "class": "custom-filter-param", "data-type": e.Type, "data-key": e.Key, "placeholder": e.Label
                }));
            });

            customFilter.append($("<div />", {
                "class": "apply-custom-filter button primary"
            }).append(this._getLocalizableText("ApplyFilter")));

            return customFilter;
        },
        _toggleQuickFilter: function (container) {
            if (this.options.quickFilter) {
                var filter = $(".filter-bar", container);

                var filterItems = this.options.quickFilter.Items;

                $(".v-quickFilterButton", filter).each(function () {
                    var filterIndex = $(this).attr("data-index");

                    if (filterItems[filterIndex]) {
                        var visible = a4.evaluateCondition(filterItems[filterIndex].DisplayCondition);
                        $(this).toggleClass("hidden", !visible);
                    }
                });

                $(".button:not(.hidden):first", filter).addClass("first-button");
                $(".button:not(.hidden):last", filter).addClass("last-button");
            }
        },
        _renderEnumControl: function (enumType, selectedValue, nullable) {
            if (!_.isObject(enumType))
                enumType = EnumDetails[enumType];

            var dropDown = $("<select />", {});

            if (nullable !== false) {
                dropDown.append($("<option />", { "value": null }));
            }

            _.each(enumType, function (e) {
                var option = $("<option />", { "value": e.Value }).append(e.Label);

                if (selectedValue && (e.Value == selectedValue || e.Name == selectedValue || e.Label == selectedValue)) {
                    option.attr("selected", "selected");
                }

                dropDown.append(option);
            });

            return dropDown;
        },
        _renderBoolControl: function (labels, selectedValue, nullable) {
            var dropDown = $("<select />", {});
            var trueLabel, falseLabel;

            if (labels) {
                trueLabel = labels["1"];
                falseLabel = labels["0"];
            }
            else {
                trueLabel = this._getLocalizableText("Yes");
                falseLabel = this._getLocalizableText("No");
            }

            if (nullable !== false) {
                dropDown.append($("<option />", {
                    "value": null
                }));
            }

            var trueOption = $("<option />", {
                "value": 1
            }).append(trueLabel);
            var falseOption = $("<option />", {
                "value": 0
            }).append(falseLabel);

            if (selectedValue) {
                if (selectedValue == trueLabel)
                    trueOption.attr("selected", "selected");
                else
                    falseOption.attr("selected", "selected");
            }

            dropDown.append(trueOption);
            dropDown.append(falseOption);

            return dropDown;
        },
        _renderAdvancedFilterRow: function (header) {
            if (this.options.advancedFilter) {
                var self = this;
                var advancedFilterRow = $("<tr />", {
                    "class": "advanced-filter"
                });

                _.each(this.columns, function (column) {
                    var filterColumn = $("<th />", {
                        "class": "advanced-filter-column"
                    });

                    if (column.IsDataColumn && column.AdvancedFilter !== false) {
                        filterColumn.attr("data-column", column.name);

                        var columnType = (column.type !== undefined ? column.type : "text").toLowerCase();

                        if ((columnType == "enum" || columnType == "multiple") && typeof EnumDetails !== "undefined" && typeof EnumDetails[column.EnumType] !== "undefined") {
                            filterColumn.append(self._renderEnumControl(column.EnumType));
                        }
                        else if (columnType == "boolean") {
                            filterColumn.append(self._renderBoolControl(column.AdvancedFilterLabels));
                        }
                        else if (columnType == "date" || columnType == "time" || columnType == "datetime") {
                            var div = $("<div />", {
                                "class": "date-filter"
                            });
                            var fromDate = $("<input />", {
                                "type": "text", "class": "v-fromDate", "placeholder": self._getLocalizableText("From")
                            });
                            var toDate = $("<input />", {
                                "type": "text", "class": "v-toDate", "placeholder": self._getLocalizableText("To")
                            });

                            if (columnType == "date") {
                                fromDate.datepicker();
                                toDate.datepicker();
                            }
                            else if (columnType == "time") {
                                fromDate.timepicker();
                                toDate.timepicker();
                            }
                            else {
                                fromDate.datetimepicker();
                                toDate.datetimepicker();
                            }

                            div.append(fromDate);
                            div.append(toDate);
                            filterColumn.append(div);
                        }
                        else {
                            var input = $("<input />", { "type": "text" });

                            //if (columnType == "numeric") {
                            //input.autoNumeric({ aSep: '', aDec: '.', aPad: false, mDec: 2, vMin: dataTableConstants.numericMinValue, vMax: dataTableConstants.numericMaxValue });
                            //}

                            filterColumn.append(input);
                        }
                    }

                    advancedFilterRow.append(filterColumn);
                });

                var clearButton = $(voxco.icons.getIcon("remove", "h-clearAdvancedFilter", { Title: this._getLocalizableText("ClearFilter") }));
                var refreshButton = $(voxco.icons.getIcon("check", "h-applyAdvancedFilter", { Title: this._getLocalizableText("ApplyFilter") }));

                $("th:last", advancedFilterRow).addClass("advanced-filter-actions-column").append(refreshButton).append(clearButton);

                header.prepend(advancedFilterRow);
            }
        },
        _bindEvents: function () {
            var self = this;
            var dataTable = this.dataTable;
            var options = this.options;

            dataTable.on("length.dt", function (e, settings, len) {
                self._saveState();
            });

            dataTable.on("order.dt", function (e, settings) {
                self._saveState( null, true );
            });

            if (self.allowRowSelection) {
                dataTable.on("select.dt", function (e, dt, type, indexes) {
                    if (dt) {
                        self._setRowSelected(dt.rows(indexes), true);
                    }
                });

                dataTable.on("deselect.dt", function (e, dt, type, indexes) {
                    self._setRowSelected(dt.rows(indexes), false);
                });

                $(this.container).on("click", ".h-selectAll", function () {
                    var rows = dataTable.rows("tr:has(.selectRow)");

                    if ($(this).hasClass("fa-square-o"))
                        rows.select();
                    else
                        rows.deselect();

                    $(this).toggleClass("fa-square-o fa-check-square");
                });
            }

            if (options.autoUpdate) {
                dataTable.on("open.dropdown", ".action-menu-column .button-group", function () {
                    self._stopAutoUpdate();
                });

                dataTable.on("close.dropdown", ".action-menu-column .button-group", function () {
                    self._startAutoUpdate();
                });
            }

            if (options.contextMenuItems.length > 0) {
                dataTable.on("mouseenter", "tbody tr", function (e) {
                    var actionMenuContainer = $("td.action-menu-column", $(this));

                    if ($(".displayOnHover.open", actionMenuContainer).length == 0) {
                        var row = dataTable.row($(this));
                        var rowData = row.data();
                        var rowIndex = row.index();

                        actionMenuContainer.html(self._renderContextMenu(rowData, rowIndex));
                    }
                });

                $(this.container).on("click", ".v-contextMenuItem", function (e) {
                    var action = $(this).attr("data-action");

                    if (action) {
                        var rowSelector;

                        if ($(this).is(".button")) {
                            rowSelector = $(this).closest("tr");
                        }
                        else {
                            var dropDownMenu = $(this).closest(".dropdown-menu");
                            var dropDownContainer = $(".dropdown-container[data-dropdownid='" + dropDownMenu.attr("id") + "']", self.container)
                            rowSelector = dropDownContainer.closest("tr");
                        }

                        var row = dataTable.row(rowSelector);
                        var rowData = row.data();
                        var rowIndex = row.index();
                        var pageInfo = dataTable.page.info();

                        if (pageInfo.serverSide)
                            rowIndex += pageInfo.start;

                        var params = $(this).attr("data-params");

                        if (params)
                            params = JSON.parse(params);

                        self._trigger("contextMenuClick", null, {
                            action: action, params: params, rowSelector: rowSelector, row: rowData, index: rowIndex
                        });
                    }
                });
            }

            var toolBarItems = this._getToolBarItems();

            if (toolBarItems.length > 0) {
                $(this.container).on("click", "div.toolBar .v-toolBarButton", function () {
                    if (!$(this).is(".disabled")) {
                        var params = {
                            action: $(this).attr("data-action")
                        };

                        if (options.rememberRowSelection) {
                            params.rows = self.selectedRows;
                        }
                        else {
                            var rows = dataTable.rows({
                                selected: true
                            })

                            params.rows = rows.data().toArray();
                            params.rowsSelector = rows.nodes().toArray();
                        }

                        self._trigger("toolBarClick", null, params);
                    }
                });
            }

            if (options.quickFilter) {
                $(this.container).on("click", "div.filter-bar.buttons .v-quickFilterButton, div.filter-bar.dropdown li", function () {
                    if (!$(this).hasClass("selected")) {
                        var container = $(this).closest(".button-group");

                        $(".selected", container).removeClass("selected");
                        $(this).addClass("selected");

                        $(".filter-bar .custom-filter-panel", self.container).hide();

                        var customFilterPanel = $(".filter-bar .custom-filter-panel[data-index='" + $(this).attr("data-index") + "']", self.container);

                        if (customFilterPanel.length > 0) {
                            customFilterPanel.show();
                        }
                        else {
                            self._applyQuickFilter();
                        }

                        $(".dropdown-toggle .v-currentFilterLabel", container).text($(this).text());
                    }
                });

                $(this.container).on("click", "div.filter-bar .apply-custom-filter", function () {
                    self._applyQuickFilter();
                });
            }

            //td.tooltip-column .icon, 
            dataTable.on("mouseenter", "td.tooltip-column", function (e) {
                if (!!$(this).attr("data-tooltip") || $(".icon", $(this)).length > 0) {
                    self._displayToolTip($(this));
                    e.stopPropagation();
                }
            });

            //Editable columns
            if (options.multiEdit) {
                dataTable.on("key", function (e, datatable, key, cell, originalEvent) {
                    if (key === 27) {
                        cell.blur();
                    }
                    else if (key < 16 || key > 20) { // Excludes Shift, Control, Alt, Pause, Caps Lock
                        var data = key === 113 ? cell.data() : null;

                        self._setCellEditable(cell, data);
                    }
                });

                dataTable.on("key-focus", function (e, datatable, cell, originalEvent) {
                    var index = cell.index();
                    var cellNode = cell.node();

                    if (options.multiEditExpand)
                        $(cellNode).height(Math.max($(cellNode).height(), 100));

                    $(datatable.row(index.row).node()).addClass("focus");
                });

                dataTable.on("key-blur", function (e, datatable, cell, originalEvent) {
                    var index = cell.index();

                    $(cell.node()).css("height", "");

                    $(datatable.row(index.row).node()).removeClass("focus");
                });

                dataTable.on("dblclick", "tbody td.editable-column", function (e) {
                    if (self.state === undefined) {
                        $("td.editable-column", self.container,).removeClass("plainText");
                    }
                    if (a4.evaluateCondition(options.multiEdit)) {
                        var cell = dataTable.cell($(this));
                        var data = cell.data();

                        if (!self.editing) {
                            self._toggleMultiEdit(true);
                            cell.focus();
                        }

                        var cellNode = cell.node();

                        if (!$(cellNode).hasClass("editing")) {
                            self._setCellEditable(cell, data);
                        }
                    }
                });
                $(window).on("beforeunload.unsavedChanges", function (e) {
                    if (a4.evaluateCondition(options.multiEdit)) {
                        var updatedRows = self.getUpdatedItems();

                        if (updatedRows.length > 0)
                            return self._getLocalizableText("UnsavedChanges");
                    }
                });

                $(this.container).on("click", ".multi-edit-toggle .button", function () {
                    if (a4.evaluateCondition(options.multiEdit)) {
                        self._toggleMultiEdit(!self.editing);
                    }
                });

                $(this.container).on("click", ".multi-edit-bar .save:not(.disabled)", function () {
                    if (a4.evaluateCondition(options.multiEdit)) {
                        self.saveChanges();
                    }
                });

                $(this.container).on("click", ".multi-edit-bar .cancel", function () {
                    if (a4.evaluateCondition(options.multiEdit)) {
                        self.refresh();
                        $(self.container).removeClass("updated");
                    }
                });

                $(this.container).on("click", ".multi-edit-bar .toggle", function () {
                    if (a4.evaluateCondition(options.multiEdit)) {
                        self.toggleColor()
                    }
                });
            }

            //Settings menu
            $(this.container).on("change", ".settings-menu li :checkbox", function () {
                var check = !$(this).is(":checked");
                $(this).prop("checked", check);
                self.toggleColumn($(this).closest("li").attr("data-column-name"), check);
            });

            $(this.container).on("click", ".settings-menu li", function () {
                var checkbox = $(this).find(":checkbox");
                checkbox.trigger("change");
            });

            if (options.displaySearchBox) {
                $(".dataTables_filter input", this.container).off(); //Important to remove default behaviour of DataTables, filtering on type

                $(this.container).on("keypress", ".dataTables_filter input", function (e) {
                    if (e.keyCode == 13) {
                        self._filterData();
                    }

                    return e.keyCode != 13;
                });

                $(this.container).on("click", ".h-filterButton", function () {
                    self._filterData();
                });
            }

            $(this.container).on("click", ".h-refreshButton:not(.disabled)", function () {
                $(this).addClass("fa-spin disabled");
                self.refresh()
            });

            if (options.advancedFilter) {
                $(this.container).on("click", ".advanced-filter-toggle .button:not(.disabled)", function () {
                    $(this).toggleClass("selected");
                    $(this).find("span").toggleClass("filter filter-white");

                    $("tr.advanced-filter", self.container).toggle();

                    self._adjustColumnHeaders(dataTable);
                    self._adjustBodyHeight();

                    if (!$(this).hasClass("selected")) {
                        self._clearAdvancedFilter();
                    }
                });

                $(this.container).on("click", ".advanced-filter-column", function () {
                    dataTable.cells({ focused: true }).cell.blur();
                });

                $(this.container).on("keypress", ".advanced-filter-column :text", function (e) {
                    if (e.keyCode == 13) {
                        self._applyAdvancedFilter();
                    }

                    return e.keyCode != 13;
                });

                $(this.container).on("click", ".h-applyAdvancedFilter:not(.disabled)", function () {
                    self._applyAdvancedFilter();
                });

                $(this.container).on("click", ".h-clearAdvancedFilter:not(.disabled)", function () {
                    self._clearAdvancedFilter();
                });
            }

            $(window).on("resize", function () {
                self._adjustColumnHeaders(dataTable);
                self._adjustBodyHeight(true);
            });

            if (options.childRow) {
                $(this.container).on("click", ".h-toggleChildRow:not(.disabled)", function () {
                    var tr = $(this).closest("tr");
                    var row = dataTable.row(tr);

                    if (row.child.isShown()) {
                        row.child.hide();
                        tr.removeClass("has-child-row");
                    }
                    else {
                        var rowData = row.data();
                        var content = _.isFunction(options.childRow.Render) ? options.childRow.Render(rowData) : rowData[options.childRow.Render];
                        row.child(content).show();
                        tr.addClass("has-child-row");
                    }
                });
            }
        },
        _initializeSelectedRows: function () {
            var self = this;
            var keyColumn = this.keyColumn;

            if (this.options.selectedRows) {
                var selectedRows;

                if (_.isString(this.options.selectedRows)) {
                    selectedRows = this.options.selectedRows.split(",");
                }
                else {
                    selectedRows = $.extend(true, {}, this.options.selectedRows);
                }

                this.selectedRows = _.map(selectedRows, function (item) {
                    if (_.isObject(item)) {
                        return item;
                    }
                    else {
                        var row = {};
                        row[keyColumn] = item;
                        return row;
                    }
                });

                this.dataTable.rows(function (index, data, node) {
                    return _.find(self.selectedRows, function (row) {
                        return row[keyColumn] == data[keyColumn];
                    }) != undefined;
                }).select();
            }

            this._setSelectedRowsLabel();
        },
        _updateCellValue: function (input, columnOptions) {
            var cellNode = input.closest("td");
            var cell = this.dataTable.cell(cellNode);
            var cellIndex = cell.index();

            if (cellIndex) {
                var rowData = cell.context[0].aoData[cellIndex.row]._aData;
                var cellName = cell.context[0].aoColumns[cellIndex.column].data;
                var inputType = input.attr("data-type");
                var value = rowData[cellName];
                var displayValue = cell.data();

                if (_.isFunction(cellName)) {
                    cellName = cell.context[0].aoColumns[cellIndex.column].name;
                }

                if (inputType == "enum") {
                    cellName = cellName.replace("Enum", "").replace("Label", "");
                    value = a4.getInputValue(input);
                    displayValue = $("option:selected", input).text();
                }
                else if (inputType == "boolean") {
                    cellName = cellName.replace("Label", "");
                    value = a4.getInputValue(input) == "1";

                    if (cellNode.hasClass("icon-column"))
                        displayValue = value ? voxco.icons.getIcon("check") : "";
                    else
                        displayValue = $("option:selected", input).text();
                }
                else if (inputType == "multiple") {
                    cellName = cellName.replace("Description", "");
                    var selectedItems = a4.getInputValue(input);

                    if (selectedItems && selectedItems.length > 0) {
                        value = _.pluck(selectedItems, columnOptions.Editable.ValueField || "Value").join(columnOptions.Editable.Delimiter || ",");
                        displayValue = _.pluck(selectedItems, columnOptions.Editable.LabelField || "Name").join(columnOptions.Editable.Delimiter || ",");
                    }
                    else {
                        value = null;
                        displayValue = "";
                    }
                }
                else {
                    value = a4.getInputValue(input);

                    if (inputType == "time" && !$.datepicker.parseTime($.timepicker.regional[a4.language].timeFormat, value))
                        value = null;

                    displayValue = value == null ? "" : value;
                }

                var updated = rowData[cellName] != value;

                cell.data(displayValue);
                rowData[cellName] = value;

                if (updated) {
                    var row = this.dataTable.row(cellNode.closest("tr"));
                    this._setRowUpdated(row, cell, cellName, value);
                }
            }
        },
        _setRowSelected: function (rows, select) {
            var self = this;
            var keyColumn = this.keyColumn;
            var rowsNodes = rows.nodes().toArray();
            var rowsData = rows.data().toArray();

            if (keyColumn) {
                _.each(rowsData, function (rowData) {
                    var key = rowData[keyColumn];

                    if (select) {
                        if (!_.some(self.selectedRows, function (item) { return item[keyColumn] == key; })) {
                            self.selectedRows.push(rowData);
                        }
                    }
                    else {
                        self.selectedRows = _.reject(self.selectedRows, function (item) {
                            return item[keyColumn] == key;
                        });
                    }
                });
            }

            //Disable inline editing when selecting a row
            if (self.editing) {
                if (self.selectedRows.length > 0) {
                    self.dataTable.cells({ focused: true }).cell.blur();
                    self.dataTable.keys.disable();
                }
                else {
                    self.dataTable.keys.enable();
                }
            }

            this._toggleToolbarItems(self.container);
            this._toggleAutoUpdate();
            this._checkSelectedRowsLimit();
            this._setSelectedRowsLabel();

            this._trigger("selectRow", null, { rows: rowsNodes, data: rowsData, isChecked: select, selectedRows: this.getSelectedItems() });
        },
        _setRowUpdated: function (row, cell, cellName, value) {
            var rowNode = row.node();
            var rowData = row.data();
            var cellNode = cell.node();
            var cellIndex = cell.index();
            var saveButton = $(".multi-edit-bar .save", this.container);
            var self = this;
            var columnOptions = cell.context[0].aoColumns[cellIndex.column];

            this.dataTable.context[0].aoData[row.index()]._a4s_updated = true;

            this.errorCells = _.reject(this.errorCells, function (c) {
                return c.column == cellIndex.column && c.columnVisible == cellIndex.columnVisible && c.row == cellIndex.row; //Improve this
            });
            this.errorRows = _.reject(this.errorRows, function (c) {
                return c == cellIndex.row; //Improve this
            });

            if (!$(this.container).hasClass("updated"))
                $(this.container).addClass("updated");

            // Verify if the column is required, otherwise we remove all errors.
            if (columnOptions.Editable && columnOptions.Editable.Required && value == null) {
                saveButton.addClass("disabled");
                $(cellNode).addClass("error");
                this.errorCells.push(cellIndex);
            }
            else {
                $(cellNode).removeClass("error");
                $(rowNode).removeClass("error");
            }

            $(rowNode).addClass("updated");
            $(cellNode).addClass("updated");

            if (this.errorCells.length == 0 && this.errorRows.length == 0)
                saveButton.removeClass("disabled");

            this._evaluateRowConditions(row);

            this._trigger("rowUpdated", null, {
                index: cellIndex.row, row: rowNode, data: rowData, fieldName: cellName, value: value, flagError: function (disableSave, fullRow) {
                    if (disableSave)
                        saveButton.addClass("disabled");

                    if (fullRow) {
                        $(rowNode).addClass("error");
                        self.errorRows.push(cellIndex.row);
                    }
                    else {
                        $(cellNode).addClass("error");
                        self.errorCells.push(cellIndex);
                    }
                }
            });
        },
        _evaluateRowConditions: function (row) {
            var rowData = row.data();
            var self = this;

            _.each(this._getVisibleColumns(), function (c) {
                if (c.Editable) {
                    var cell = self.dataTable.cell(row.index(), c.idx);
                    var node = $(cell.node());
                    var editableCondition = _.isObject(c.Editable) ? c.Editable.DisplayCondition : c.Editable;

                    node.toggleClass("editable-column", !editableCondition || a4.evaluateCondition(editableCondition, rowData));
                }
            });
        },
        _checkSelectedRowsLimit: function () {
            if (this.selectedRows && this.options.limitRowSelection) {
                if (this.selectedRows.length >= this.options.limitRowSelection) {
                    $("tr:not(.selected) .selectRow", this.container).addClass("disabled");
                }
                else {
                    $("tr .selectRow", this.container).removeClass("disabled");
                }
            }
        },
        _setSelectedRowsLabel: function () {
            var label = "";

            if (this.selectedRows && this.selectedRows.length > 0) {
                if (this.options.limitRowSelection) {
                    label = this.selectedRows.length == 1 ? this._getLocalizableText("SelectedItemLimit") : this._getLocalizableText("SelectedItemsLimit");
                }
                else {
                    label = this.selectedRows.length == 1 ? this._getLocalizableText("SelectedItem") : this._getLocalizableText("SelectedItems");
                }

                label = "(" + label.replace(/{count}/g, this.selectedRows.length).replace(/{limit}/g, this.options.limitRowSelection) + ")";
            }

            $(".v-selectedRows", this.container).text(label);
        },
        _filterData: function () {
            var filterValue = $(".dataTables_filter input", this.container).val();
            this.dataTable.search(filterValue).draw();
        },
        _renderAdvancedFilterToggleButton: function (container) {
            if (this.options.advancedFilter) {
                var advancedFilterToggle = $("<div />", {
                    "class": "button icon-only", "title": this._getLocalizableText("ToggleAdvancedFilter")
                }).append(voxco.icons.getIcon("filter"));
                $(".advanced-filter-toggle", container).append(advancedFilterToggle);
            }
        },
        _renderMultiEditControls: function (container) {
            if (this.options.multiEdit) {
                var multiEditToggle = $("<div />", { "class": "button", "title": this._getLocalizableText("ToggleMultiEdit") });

                multiEditToggle.append(voxco.icons.getIcon("edit", "icon-left")).append(this._getLocalizableText("MultiEdit"));

                $(".multi-edit-toggle", container).append(multiEditToggle);

                var multiEditSaveBar = $('.multi-edit-bar', container);
                multiEditSaveBar.append($("<div />", { "class": "link-button cancel small" }).append(this._getLocalizableText("Cancel")));
                multiEditSaveBar.append($("<div />", { "class": "button save primary small" }).append(this._getLocalizableText("SaveChanges")));
                multiEditSaveBar.append($("<div />", { "class": "button toggle small" }).append("&#60;&#47;&#62;"));
            }
        },
        _renderSettingsMenu: function (container) {
            var settingsMenu = $(".settings-menu", container);

            if (settingsMenu.length > 0) {
                var buttonGroup = $("<div />", { "class": "button-group dropdown-container" });
                var self = this;

                buttonGroup.append($("<div />", { "class": "button icon-only dropdown-toggle" }).append(voxco.icons.getIcon("columns")).append(voxco.icons.getIcon("caret-down", "icon-right")));

                var menu = $("<ul />", {
                    "class": "dropdown-menu keep-open"
                });

                _.each(this.options.columns, function (column) {
                    if (column.Data && !column.Tooltip) {
                        var checkbox = $("<input type='checkbox'>").prop("checked", self._isVisibleColumn(column));

                        var title = column.Title;

                        if (!title) {
                            title = self._getLocalizableText(column.Name) || column.Name;
                        }

                        var menuItem = $("<li />", { "data-column-name": column.Name }).append($("<a />", { "html": title }).prepend(checkbox));

                        menuItem.toggle(!column.HideInSelector);

                        menu.append(menuItem);
                    }
                });

                if (this.options.customColumns)
                {
                    if (this.options.customColumns.Visible)
                    {
                        var title = this.options.customColumns.Label;
                        var button = $("<input type='button' class='btn btn-add-custom-column' value='{0}'>".replace("{0}", title));
                        var menuItem = $("<li />", { "data-column-name": "CustomColumnSelector" }).append($("<a />").prepend(button));
                        menu.append(menuItem);
                    }
                }

                buttonGroup.append(menu);

                settingsMenu.append(buttonGroup);
            }
        },
        _getSelectedFilterIndex: function () {
            var filterIndex;
            var selectedFilter = $(".filter-bar .selected", this.container);

            if (selectedFilter.length > 0)
                filterIndex = selectedFilter.attr("data-index");
            else if (this.state)
                filterIndex = this.state.QuickFilter;

            return filterIndex;
        },
        _getAjaxParams: function (data) {
            var ajaxParams = {
                tableParams: this._getTableParams(data)
            };

            if (this.options.ajaxParams) {
                ajaxParams = _.extend(ajaxParams, this.options.ajaxParams);
            }

            //Remove this when all methods are updated server side (Quick filter params should be retrieved in DataTableParams!)
            if (ajaxParams.tableParams.QuickFilter) {
                ajaxParams = _.extend(ajaxParams, ajaxParams.tableParams.QuickFilter);
            }

            return ajaxParams;
        },
        _getTableParams: function (aoData) {
            var data = {
            };

            if (!aoData && this.dataTable)
                aoData = this.dataTable.ajax.params();

            if (aoData) {
                data.Echo = aoData.draw;
                data.PageStart = aoData.start;
                data.PageLength = aoData.length;

                if (aoData.search) {
                    data.Search = aoData.search.value;
                    data.IsSearch = data.Search != "";
                }

                if (aoData.order && aoData.order.length > 0) {
                    var column = aoData.columns[aoData.order[0].column];
                    data.SortColumn = column.name;
                    data.SortAscending = aoData.order[0].dir != "desc";
                    data.IsSort = true;
                }

                if (this.options.quickFilter && this.options.quickFilter.Items && this.options.quickFilter.Items.length > 0) {
                    data.QuickFilter = this.appliedQuickFilter.params;

                    if (this.options.quickFilter.IncludeSelectedStates && ($(".v-selected.selected", this.container).length > 0 || $(".v-notSelected.selected", this.container).length > 0)) {
                        data.Selected = "'" + _.pluck(this.selectedRows, this.keyColumn).join("','") + "'";
                        data.ExcludeSelected = ($(".v-notSelected.selected", this.container).length > 0);
                    }
                }

                if (this.options.advancedFilter && this.appliedAdvancedFilter)
                    data.AdvancedFilter = this.appliedAdvancedFilter;

                data.VisibleColumns = this.getVisibleColumns();
            }

            return data;
        },
        _toggleMultiEditButton: function (container) {
            $(".multi-edit-toggle", container).hide();

            if (a4.evaluateCondition(this.options.multiEdit)) {
                var hasEditableColumns = $("td.editable-column", container).length > 0;

                $(".multi-edit-toggle", container).toggle(hasEditableColumns);
            }
        },
        _toggleMultiEdit: function (editing) {
            if (this.editing != editing) {
                var dataTable = this.dataTable;

                this.editing = editing;
                this.errorCells = [];
                this.errorRows = [];
                this._clearUpdatedRows();      

                if (this.state && this.state.PlainText) {
                    $("td.editable-column", this.container,).addClass("plainText");
                    this._saveState(true, false); 
                } else {
                    $("td.editable-column", this.container,).removeClass("plainText");
                    this._saveState(false, false);
                }

                $(this.container).toggleClass("editing", editing);

                if (this.options.serverSide) {
                    dataTable.column("UpdatedRow:name").visible(editing);
                    dataTable.column("SelectRow:name").visible(!editing);
                }

                if (this.options.multiEditExpand)
                    $(this.container).toggleClass("expanded", editing);

                $('.multi-edit-toggle .button', this.container).toggleClass("selected", editing);

                if (editing) {
                    dataTable.keys.enable();

                    if (this.options.serverSide) {
                        //Disable paging
                        this.dataTable.context[0].oInit.paging = false;

                        //Disable columns sorting
                        _.each(this._getVisibleColumns(), function (c) {
                            c.bSortable = false;
                        });
                    }

                    //Deselect selected rows
                    this.selectedRows = [];
                    this.dataTable.rows({ selected: true }).deselect();
                }
                else {
                    dataTable.cells({ focused: true }).cell.blur();
                    dataTable.keys.disable();

                    //Reenable paging
                    dataTable.context[0].oInit.paging = true;

                    //Reenable columns sorting
                    for (var i = 0; i < this.columns.length; i++) {
                        dataTable.context[0].aoColumns[i].bSortable = this.columns[i].orderable;
                    }
                }

                this._adjustColumnHeaders(dataTable);
                this._adjustBodyHeight(true);
                this._toggleAutoUpdate();

                this._trigger("toggleMultiEdit", null, { editing: editing });
            }
        },
        _setCellEditable: function (cell, data) {
            //Check if cell is already in edition before doing this.

            var self = this;
            var dataTable = this.dataTable;
            var index = cell.index();

            var column = this.dataTable.column(index.column);
            var row = this.dataTable.row(index.row);
            var rowData = row.data();
            var columnOptions = column.context[0].aoColumns[column.index()];

            if (columnOptions.Editable) {
                var editableCondition = _.isObject(columnOptions.Editable) ? columnOptions.Editable.DisplayCondition : columnOptions.Editable;

                if (editableCondition && !a4.evaluateCondition(editableCondition, rowData))
                    return;
            }

            this.dataTable.keys.disable();

            var node = $(cell.node());
            var originalValue = node.html();

            var input = this._renderEditableCellInput(columnOptions, data);

            var w = node.outerWidth(true);
            node.addClass("editing");
            node.outerWidth(w); //Fix cell width when editing
            node.html(input);

            var keyDownHandler = function (e) {
                if (e.keyCode == 13 || e.keyCode == 9) {
                    $(this).blur();
                }
                else if (e.keyCode == 27) {
                    node.html(originalValue);
                    dataTable.keys.enable();
                    node.removeClass("editing");
                }
            };

            var stopEditingValue = function (input) {
                self._updateCellValue(input, columnOptions);
                dataTable.keys.enable();
                node.removeClass("editing");
            };

            if (columnOptions.type) {
                switch (columnOptions.type) {
                    case "numeric":
                        var minValue = dataTableConstants.numericMinValue;
                        var maxValue = dataTableConstants.numericMaxValue;
                        var decimals = 2;

                        if (columnOptions.Editable) {
                            if (columnOptions.Editable.MinValue != null)
                                minValue = columnOptions.Editable.MinValue;
                            if (columnOptions.Editable.MaxValue != null)
                                maxValue = columnOptions.Editable.MaxValue;
                            if (columnOptions.Editable.Decimals != null)
                                decimals = columnOptions.Editable.Decimals;
                        }

                        input.autoNumeric({ mDec: decimals, vMin: minValue, vMax: maxValue });
                        break;
                    case "datetime":
                        input.datetimepicker({
                            onClose: function (val, inst) {
                                stopEditingValue(inst.input);
                            }
                        }).focus();
                        break;
                    case "date":
                        input.datepicker({
                            onClose: function (val, inst) {
                                stopEditingValue(inst.input);
                            }
                        }).focus();
                        break;
                    case "time":
                        input.timepicker({
                            onClose: function (val, inst) {
                                stopEditingValue(inst.input);
                            }
                        }).focus();
                        break;
                    case "richtext":
                        input.a4richTextEditor({
                            library: true,
                            piping: true,
                            inline: true,
                            initOnClick: false,
                            ready: function (e, d) {
                                d.editor.$el.focus();
                            },
                            blur: function () {
                                stopEditingValue($(this));
                            },
                            keydown: keyDownHandler
                        });
                        break;
                    case "multiple":
                        var availableValues = _.isFunction(columnOptions.Editable.AvailableValues) ? columnOptions.Editable.AvailableValues(rowData) : columnOptions.Editable.AvailableValues;
                        var valueField = columnOptions.Editable.ValueField || "Value";
                        var labelField = columnOptions.Editable.LabelField || "Name";
                        var delimiter = columnOptions.Editable.Delimiter || ",";
                        var selectedItems = [];

                        if (data) {
                            _.each(data.split(delimiter), function (d) {
                                var selectedItem = _.find(availableValues, function (v) { return v[labelField] == d });

                                if (selectedItem == null && columnOptions.Editable.AllowCreate) {
                                    selectedItem = {};
                                    selectedItem[valueField] = d;
                                    selectedItem[labelField] = d;

                                    availableValues.push(selectedItem);
                                }

                                if (selectedItem != null)
                                    selectedItems.push(selectedItem[valueField]);
                            });
                        }

                        input.selectize({
                            options: availableValues,
                            items: selectedItems,
                            allowEmptyOption: true,
                            openOnFocus: false,
                            openOnRemove: false,
                            closeAfterSelect: true,
                            selectOnTab: true,
                            create: columnOptions.Editable.AllowCreate || false,
                            persist: false,
                            valueField: valueField,
                            labelField: labelField,
                            searchField: labelField,
                            delimiter: delimiter,
                            maxItems: columnOptions.Editable.MaxItems,
                            dropdownParent: "body",
                            onDropdownOpen: function (dropdown) {
                                this.$control_input.off("keydown.a4s");
                            },
                            onDropdownClose: function (dropdown) {
                                this.$control_input.on("keydown.a4s", keyDownHandler);
                            },
                            onInitialize: function () {
                                this.$control_input.focus();
                                this.$control_input.on("keydown.a4s", keyDownHandler);
                            },
                            onBlur: function () {
                                stopEditingValue(this.$input);
                            }
                        });
                        break;
                }
            }

            if (columnOptions.type != "multiple" && columnOptions.type != "richtext" && columnOptions.type != "datetime" && columnOptions.type != "date" && columnOptions.type != "time") {
                input.on("focus", function () {
                    $(this).val($(this).val());
                });

                input.on("keydown", keyDownHandler);

                input.on("blur", function (e) {
                    stopEditingValue($(this));
                });

                if (input.is("textarea")) {
                    input.height(1);
                    input.height(input[0].scrollHeight);

                    input.on("keyup", function (e) {
                        $(this).height(1);
                        $(this).height($(this)[0].scrollHeight);
                    });
                }

                input.trigger("focus");
            }
            
            if (columnOptions.type == "enum") {
                $("option", input[0]).on("click", function (e) {
                    stopEditingValue(input);
                });
            }
        },
        _setEditableItems: function (context) {
            $("input[data-type=numeric]", context).not(".hasAutoNumeric").autoNumeric({ vMin: dataTableConstants.numericMinValue, vMax: dataTableConstants.numericMaxValue });

            $("input[data-type=datetime]", context).not(".hasDatepicker").datetimepicker();

            $("input[data-type=date]", context).not(".hasDatepicker").datepicker();

            $("input[data-type=time]", context).not(".hasDatepicker").timepicker();

            $(".editable.v-richText", context).a4richTextEditor({ inline: true });
        },
        _clearUpdatedRows: function () {
            var context = this.dataTable.context[0];

            var updatedRows = this.dataTable.rows({
                updated: true
            });

            updatedRows.indexes().each(function (i) {
                context.aoData[i]._a4s_updated = false;
            });

            $(updatedRows.nodes()).removeClass("updated");

            $(this.container).removeClass("updated");
        },
        _getCurrentQuickFilter: function () {
            var filterIndex = this._getSelectedFilterIndex();
            var filter;
            var filterParams;
            var custom = false;

            if (filterIndex != undefined) {
                filter = this.options.quickFilter.Items[filterIndex];
            }

            if ((!filter || !a4.evaluateCondition(filter.DisplayCondition)) && this.options.quickFilter.IncludeAll === false) {
                filterIndex = 0;
                filter = this.options.quickFilter.Items[filterIndex];
            }

            if (filter && a4.evaluateCondition(filter.DisplayCondition)) {
                filterParams = filter.AjaxParams;

                if (filter.CustomInputs) {
                    custom = true;

                    var panel = $(".custom-filter-panel[data-index='" + filterIndex + "']", this.container);

                    $(".custom-filter-param", panel).each(function () {
                        filterParams[$(this).attr("data-key")] = $(this).val();
                    });
                }
            }

            return {
                index: filterIndex, params: filterParams, custom: custom
            };
        },
        _applyQuickFilter: function () {
            var filter = this._getCurrentQuickFilter();

            this.appliedQuickFilter = filter;

            this.refresh(true);

            this._trigger("applyQuickFilter", null, { filter: filter });

            this._saveState();
        },
        _getCurrentAdvancedFilter: function () {
            var self = this;
            var advancedFilterRow = $("tr.advanced-filter", this.container);
            var advancedFilter = [];

            if (advancedFilterRow.is(":visible")) {
                $(".advanced-filter-column[data-column]", advancedFilterRow).each(function () {
                    var column = self._getColumnByName($(this).attr("data-column"));

                    if (column.type == "date" || column.type == "time" || column.type == "datetime") {
                        var fromDate = $(this).find(".v-fromDate").val();
                        var toDate = $(this).find(".v-toDate").val();

                        if (fromDate || toDate) {
                            advancedFilter.push({
                                "Name": column.name, "Value": fromDate, "OtherValue": toDate, "Type": column.type
                            });
                        }
                    }
                    else {
                        var value = $(this).find(":input").val();

                        if (value) {
                            advancedFilter.push({
                                "Name": column.name, "Value": value, "Type": column.type
                            });
                        }
                    }
                });
            }

            return advancedFilter;
        },
        _applyAdvancedFilter: function () {
            var filter = this._getCurrentAdvancedFilter();

            if (!_.isEqual(this.appliedAdvancedFilter, filter)) {
                this.appliedAdvancedFilter = filter;

                this.dataTable.draw(true);

                this._trigger("applyAdvancedFilter", null, {
                    filter: filter
                });
            }
        },
        _clearAdvancedFilter: function () {
            $("tr.advanced-filter :input", this.container).val("");

            if (this.appliedAdvancedFilter) {
                this.appliedAdvancedFilter = null;
                this.dataTable.draw(true);
            }
        },
        _startAutoUpdate: function () {
            var self = this;
            var autoUpdateDelay = _.isNumber(this.options.autoUpdate) ? this.options.autoUpdate : dataTableConstants.autoUpdateDelay;

            if (!this.autoUpdateTimerId) {
                this.autoUpdateTimerId = setInterval(function () {
                    $(".h-refreshButton", self.container).addClass("fa-spin disabled");
                    self.refresh();
                }, autoUpdateDelay * 1000);
            }
        },
        _stopAutoUpdate: function () {
            if (this.autoUpdateTimerId) {
                clearInterval(this.autoUpdateTimerId);
                this.autoUpdateTimerId = null;
            }
        },
        _getToolBarItems: function () {
            var toolBarItems;

            if (this.options.toolBar) {
                if (_.isArray(this.options.toolBar))
                    toolBarItems = this.options.toolBar;
                else if (_.isObject(this.options.toolBar) && this.options.toolBar.Items)
                    toolBarItems = this.options.toolBar.Items;
            }
            else if (this.options.toolBarItems) {
                toolBarItems = this.options.toolBarItems;
            }

            return toolBarItems;
        },
        _getToolBarParams: function () {
            var toolBarParams;

            if (this.options.toolBarParams) {
                toolBarParams = this.options.toolBarParams;
            }

            return toolBarParams;
        },
        _adjustBodyHeight: function (force) {
            if (this.options.height == "full") {
                var scrollBody = $(".dataTables_scrollBody", this.container);
                var newBodyBoundingRect = scrollBody[0].getBoundingClientRect();

                if (force || (!this.bodyBoundingRect || this.bodyBoundingRect.top != newBodyBoundingRect.top || this.bodyBoundingRect.bottom != newBodyBoundingRect.bottom) && newBodyBoundingRect.top > 0 && newBodyBoundingRect.bottom > 0) {
                    newBodyBoundingRect = scrollBody[0].getBoundingClientRect();

                    this.bodyBoundingRect = newBodyBoundingRect;

                    var height;
                    var dialog = $(this.container).closest(".dialog-main");
                    var footerHeight = $(".bottom", this.container).outerHeight(true);
                    var wrapperMarginBottom = $(this.container).css("margin-bottom").replace("px", "");

                    if (dialog.length > 0) {
                        var contentHeight = $(".content", dialog).outerHeight(true);
                        var wrapperMarginTop = $(this.container).css("margin-top").replace("px", "");
                        var contentPadding = 0;

                        height = contentHeight - $(this.container).position().top - scrollBody.position().top - footerHeight - wrapperMarginBottom - wrapperMarginTop;
                    }
                    else {
                        height = $(window).height() - newBodyBoundingRect.top - footerHeight - wrapperMarginBottom;
                    }

                    scrollBody.css("maxHeight", Math.max(height, 200)); //Grid should have at least 200px                    
                }
            }
        },
        _displayToolTip: function (element) {
            var self = this;
            var tooltip = $("div.tooltip-content", this.container);

            if (tooltip.length == 0) {
                tooltip = $("<div />", { "class": "tooltip-content" });
                $(this.container).append(tooltip);
            }

            tooltip.html(voxco.icons.getIcon("loading"));
            tooltip.show();
            tooltip.position({ my: "left middle", at: "right middle", of: $(element) });

            var clearTooltipTimer = function () {
                if (self.tooltiptimer) {
                    window.clearTimeout(self.tooltiptimer);
                    self.tooltiptimer = null;
                }
            };

            clearTooltipTimer();

            tooltip.on("mouseenter", function (e) {
                clearTooltipTimer();
            });

            tooltip.add(element).on("mouseleave", function (e) {
                if (!self.tooltiptimer) {
                    self.tooltiptimer = window.setTimeout(function () {
                        tooltip.hide();
                        tooltip.off("mouseenter");
                        tooltip.off("mouseleave");
                        element.off("mouseleave");
                    }, 600);
                }
            });

            var cell = $(element).is("td") ? element : $(element).closest("td");

            var contentPromise = cell.attr("data-tooltip");

            if (contentPromise == null) {
                var cellData = this.dataTable.cell(cell).data();

                if (_.isFunction(cellData)) {
                    var row = $(this).closest("tr");
                    var rowData = dataTable.row(row).data();
                    contentPromise = cellData(rowData);
                }
                else {
                    contentPromise = cellData;
                }
            }

            $.when(contentPromise).then(function (tooltipContent) {
                if (tooltipContent) {
                    cell.attr("data-tooltip", tooltipContent);
                    tooltip.html(tooltipContent);
                    tooltip.position({ my: "left middle", at: "right middle", of: $(element), collision: "flipfit", within: self.container });
                }
            });
        },
        _getEnumLabel: function (enumType, value) {
            var label = "";

            if (!_.isObject(enumType))
                enumType = EnumDetails[enumType];

            if (enumType != null) {
                var enumValue = _.find(enumType, function (item) {
                    return item.Value == value;
                });

                if (enumValue != null)
                    label = enumValue["Label"];
            }

            return label;
        },
        _getVisibleColumns: function () {
            return _.filter(this.dataTable.context[0].aoColumns, function (c) {
                return c.IsDataColumn && c.bVisible
            });
        },
        _getEditMultipleLabel: function (rowData, columnOptions, value) {
            var availableValues = _.isFunction(columnOptions.Editable.AvailableValues) ? columnOptions.Editable.AvailableValues(rowData) : columnOptions.Editable.AvailableValues;
            var valueField = columnOptions.Editable.ValueField || "Value";
            var labelField = columnOptions.Editable.LabelField || "Name";
            var delimiter = columnOptions.Editable.Delimiter || ",";

            var values = _.chain(availableValues).filter(function (d) { return d[valueField] == value }).pluck(labelField);

            return values.join(delimiter);
        },
        refresh: function (resetPagination, resetSelectedRows) {
            if (resetSelectedRows)
                this.selectedRows = [];

            if (this.options.multiEdit) {
                if (this.options.serverSide)
                    this._toggleMultiEdit(false);
                else
                    this.dataTable.keys.enable();
            }

            this.currentScrollPosition = $(".dataTables_scrollBody", this.container).scrollTop();

            this.dataTable.draw(resetPagination || false);
        },
        getPage: function () {
            return this.dataTable.page.info().page;
        },
        getPageLength: function () {
            return this.dataTable.page.info().length;
        },
        getPageStart: function () {
            return this.dataTable.page.info().start;
        },
        getDisplayedRecords: function () {
            return this.dataTable.page.info().recordsDisplay;
        },
        getTotalRecords: function () {
            return this.dataTable.page.info().recordsTotal;
        },
        getVisibleColumns: function (useData) {
            return _.pluck(this._getVisibleColumns(), useData ? "mData" : "sName");
        },
        toggleColumns: function (columnNames, showOrHide, toggleSelector) {
            var self = this;

            _.each(columnNames, function (columnName) {
                self.toggleColumn(columnName, showOrHide, toggleSelector);
            });
        },
        toggleColumn: function (columnName, showOrHide, toggleSelector) {
            var column = this.dataTable.column(columnName + ":name");

            if (showOrHide == undefined) {
                showOrHide = !column.visible();
            }

            column.visible(showOrHide);

            var selectorItem = $(".settings-menu li[data-column-name='" + columnName + "']", this.container);

            $(":checkbox", selectorItem).prop("checked", showOrHide);

            if (toggleSelector)
                selectorItem.toggle(showOrHide);

            //Update empty row colspan
            $("td.dataTables_empty", this.container).attr("colspan", $("thead tr.header-row th", this.container).length);

            this._toggleMultiEditButton(this.container);

            this._adjustBodyHeight();

            this._saveState();
        },
        toggleSettingMenuOption: function (columnName, findInSelector, visible, selectorNewText) {
            var selectorItem = $(".settings-menu li[data-column-name='" + columnName + "']", this.container);
            if (selectorItem) {
                if (visible) {
                    selectorItem.show();
                }
                else {
                    selectorItem.hide();
                }

                if (selectorNewText) {
                    var textSelector = selectorItem.find(findInSelector)
                    if (textSelector.length > 0) {
                        textSelector.contents()
                            .filter(function () {
                                // Filter out empty or whitespace-only text nodes
                                if (selectorNewText && this.nodeType === 3 && this.nodeValue.trim() !== '') {
                                    this.nodeValue = selectorNewText;
                                }
                            });
                    }
                }

                this._saveState();
            }
        },
        changeColumnTitle: function (columnName, columnTitle) {
            var header = this.dataTable.column(columnName + ":name").header();
            if (header) {
                $(".column-title", header).text(columnTitle);
            }
        },
        toggleToolBarItem: function (itemAction, showOrHide) {
            var toolBarItem = _.find(this._getToolBarItems(), function (item) {
                return item.Action == itemAction;
            });
            if (toolBarItem) {
                if (showOrHide == undefined) {
                    showOrHide = !toolBarItem.Disabled;
                }

                toolBarItem.Disabled = !showOrHide;
            }
        },
        getSelectedItems: function () {
            var selectedRows = [];

            if (this.dataTable) {
                if (this.options.rememberRowSelection) {
                    selectedRows = this.selectedRows;
                }
                else {
                    selectedRows = this.dataTable.rows({
                        selected: true
                    }).data().toArray();
                }

                return selectedRows;
            }

            return selectedRows;
        },
        getUpdatedItems: function () {
            return this.dataTable.rows({
                updated: true
            }).data().toArray();
        },
        updateItem: function (index, item) {
            var row = this.dataTable.row(index);
            var rowData = row.context[0].aoData[index]._aData;

            for (var property in item) {
                if (item.hasOwnProperty(property)) {
                    var column = this.dataTable.column(property + ":name");

                    if (column && column.length > 0) {
                        var columnOptions = column.context[0].aoColumns[column.index()];
                        var cell = this.dataTable.cell(index, column.index());
                        var value = item[property];

                        if (cell && cell.length > 0 && cell.data() != value) {
                            if (columnOptions.type == "enum") {
                                var displayValue = this._getEnumLabel(columnOptions.EnumType, value);
                                cell.data(displayValue);
                                rowData[columnOptions.name] = value;
                            }
                            else if (columnOptions.type == "multiple") {
                                var displayValue = this._getEditMultipleLabel(rowData, columnOptions, value);
                                cell.data(displayValue);
                                rowData[columnOptions.name] = value;
                            }
                            else {
                                cell.data(value);
                            }

                            this._setRowUpdated(row, cell, property, value);
                        }
                    }
                    else if (rowData && property in rowData) {
                        rowData[property] = item[property];
                    }
                }
            }
        },
        getCurrentPage: function () {
            return this.dataTable.page.info().page;
        },
        setCurrentPage: function (page, callback) {
            if (callback) {
                this.dataTable.one("draw", callback);
            }

            this.dataTable.page(page).draw(false);
        },
        clearTable: function () {
            this.dataTable.clear().draw();
        },
        deleteRow: function (row) {
            this.dataTable.row(row).remove().draw(false);
        },
        getNodes: function () {
            return this.dataTable.rows().nodes();
        },
        getTableParams: function () {
            return this._getTableParams();
        },
        getRowsData: function () {
            return this.dataTable.rows().data().toArray();
        },
        getRowData: function (index) {
            return this.dataTable.row(index).data();
        },
        selectRow: function (index) {
            return this.dataTable.row(index).select();
        },
        getCell: function (rowIndex, property) {
            var column = this.dataTable.column(property + ":name");
            return this.dataTable.cell(rowIndex, column.index());
        },
        getAjaxParams: function () {
            return this._getAjaxParams();
        },
        addRow: function (data) {
            this.dataTable.rows.add(data).draw(false);
        },
        saveChanges: function () {
            var self = this;
            var updatedRows = self.getUpdatedItems();

            if (updatedRows && updatedRows.length > 0) {
                self._trigger("rowsUpdated", null, {
                    rows: updatedRows, multiEditSaveCallback: function () {
                        self.refresh();

                        $(self.container).removeClass("updated");
                    }
                });
            }
            else {
                self._toggleMultiEdit(false);
                self.refresh();

                $(self.container).removeClass("updated");
            }
        },
        toggleColor: function () {
            if ($(".plainText")[0]) {
                $("td.editable-column", this.container,).removeClass("plainText");
                this._saveState(false, false);
            } else {
                $("td.editable-column", this.container,).addClass("plainText");
                this._saveState(true, false);
            }
        },
        sort: function (sortParams) {
            this.dataTable.order(sortParams);
        },
        triggerChanges: function () {
            var self = this;
            var dataTable = this.dataTable;
            var updatedCells = this.dataTable.cells({
                updated: true
            });
            var saveButton = $(".multi-edit-bar .save", this.container);

            this.errorCells = [];
            this.errorRows = [];

            saveButton.removeClass("disabled");

            _.each(updatedCells[0], function (index) {
                var cell = dataTable.cell(index);
                var cellNode = cell.node();
                var row = dataTable.row(cellNode.closest("tr"));
                var rowNode = row.node();
                var rowData = row.data();
                var cellName = cell.context[0].aoColumns[index.column].data;
                var value = cell.data();

                $(cellNode).removeClass("error");
                $(rowNode).removeClass("error");

                self._trigger("rowUpdated", null, {
                    index: index.row, row: rowNode, data: rowData, fieldName: cellName, value: value, flagError: function (disableSave, fullRow) {
                        if (disableSave)
                            saveButton.addClass("disabled");

                        if (fullRow) {
                            $(rowNode).addClass("error");
                            self.errorRows.push(index.row);
                        }
                        else {
                            $(cellNode).addClass("error");
                            self.errorCells.push(index);
                        }
                    }
                });
            });
        },
        _adjustColumnHeaders: function (api) {
            setTimeout(function () {
                var container = api.table().container();

                var currentScrollPosition = $(".dataTables_scrollBody", container).scrollTop();

                api.columns.adjust();

                $(".dataTables_scrollBody", container).scrollTop(currentScrollPosition);
            }, 0);
        }
    });
}(jQuery));